<%
	Class XDAL
		Private objCnn
		Private connstr
		Private query
		Private pagecnt
		Private ra
		Private dbug

		Public Property Let ConnectionString(str)
			connstr = str
		End Property

		Public Property Let Debug(ByVal blnDebug)
			dbug = blnDebug
		End Property

		Public Property Get Pages() 
			Pages = pagecnt
		End Property

		Public Property Get RecordsAffected()
			RecordsAffected = ra
		End Property

		Public Property Get LastQuery()
			LastQuery = query
		End Property

		Public Sub Connect()
			If dbug Then
				Response.Write("<b>Called XDAL.Connect():</b><br />")
				Response.Write("<b>ConnectionString:</b> " & connstr & "<p />")				
			End If

			Set objCnn = Server.CreateObject("ADODB.Connection")
			Call objCnn.Open(connstr)
			objCnn.CursorLocation = 3 'adUseClient
		End Sub

		Public Sub Disconnect()
			If dbug Then
				Response.Write("<b>Called XDAL.Disconnect():</b><br />")
			End If

			objCnn.Close()
			Set objCnn = Nothing
		End Sub

		Private Function EscapeParam(param)
			If Application("DBType") = 1 Then
				param = Replace(param, "\", "\\")
				param = Replace(param, "'", "\'")
			Else
				param = Replace(param, "'", "''")
			End If
			EscapeParam = param
		End Function

		Private Function IsGUID(Field)
			Dim objRegExp
			Set objRegExp = New RegExp
			objRegExp.IgnoreCase = False
			objRegExp.Pattern = "^\{?[a-fA-F\d]{8}-([a-fA-F\d]{4}-){3}[a-fA-F\d]{12}\}?$"
			IsGUID = objRegExp.Test(Field)
			Set objRegExp = Nothing	
		End Function

		Private Function BuildSQL(strSQL, params)
			Dim i, sql, strNewVal
			sql = strSQL
			If IsArray(params) Then
				For i = LBound(params) To UBound(params)
					If Len(params(i)) = 0 Then
						strNewVal = "''"
					Else
						If IsNumeric(params(i)) AND Instr(params(i), ".") = 0 Then 
							strNewVal = params(i)
						Else
							Select Case(VarType(params(i)))
								Case vbBoolean, vbDecimal, vbDouble, vbInteger, vbLong, vbSingle:
									strNewVal = params(i)
								Case Else:
									If IsGUID(params(i))  Then
										strNewVal = "'" & params(i) & "'"
									Else
										strNewVal = "'" & EscapeParam(params(i)) & "'"
									End If
							End Select
						End If
					End If
					sql = Replace(sql, "{" & i & "}", strNewVal)
				Next
			End If
			query = sql
			BuildSQL = sql
			If dbug Then
				Response.Write("<b>SQL Query:</b> " & sql & "<br />")
			End If
		End Function

		Public Sub OpenPaged(ByRef arr, page, pagesize, sql, params)
			If dbug Then
				Response.Write("<b>Called XDAL.OpenPaged():</b><br />")
			End If

			If NOT IsNumeric(page) OR page = 0 Then
				page = 1
			End If

			Dim objRst, i, strField, strFields
			Set objRst = Server.CreateObject("ADODB.Recordset")
			objRst.CursorLocation = 3 'adUseClient
			Call objRst.Open(BuildSQL(sql, params), objCnn, 3, 4) 'adOpenStatic, adLockBatchOptimistic
			objRst.PageSize = pagesize
			If objRst.BOF OR objRst.EOF Then
				pagecnt = -1
				objRst.Close()
				Set objRst = Nothing
				Redim arr(0, -1)
			Else
				pagecnt = objRst.PageCount
				arr = objRst.GetRows(pagesize)
				objRst.Close()
				Set objRst = Nothing
			End If
		End Sub

		Public Sub Open(ByRef arr, sql, params)
			If dbug Then
				Response.Write("<b>Called XDAL.Open():</b><br />")
			End If

			Dim objRst, i, strField
			Set objRst = Server.CreateObject("ADODB.Recordset")
			objRst.CursorLocation = 3 'adUseClient
			Call objRst.Open(BuildSQL(sql, params), objCnn, 3, 1) 'adOpenStatic, adLockReadOnly
			If objRst.BOF OR objRst.EOF Then
				objRst.Close()
				Set objRst = Nothing
				Redim arr(0, -1)
			Else
				arr = objRst.GetRows()
				objRst.Close()
				Set objRst = Nothing
			End If
		End Sub

		Public Sub Execute(sql, params)
			ra = -1
			If dbug Then
				Response.Write("<b>Called XDAL.Execute():</b><br />")
			End If

			sql = BuildSQL(sql, params)
			Call objCnn.Execute(sql, ra, 128) 'adExecuteNoRecords
		End Sub

		Public Function GetValue(sql, params)
			If dbug Then
				Response.Write("<b>Called XDAL.GetValue():</b><br />")
			End If

			sql = BuildSQL(sql, params)
			Dim objRst
			Set objRst = Server.CreateObject("ADODB.Recordset")
			objRst.CursorLocation = 3 'adUseClient
			Call objRst.Open(sql, objCnn, 3, 1) 'adOpenStatic, adLockReadOnly
			If objRst.BOF OR objRst.EOF Then
				objRst.Close()
				Set objRst = Nothing
				GetValue = Empty
			Else
				GetValue = objRst.Fields(0)
				objRst.Close()
				Set objRst = Nothing
			End If
		End Function

		Public Sub GetRows(ByRef arr, rows, sql, params)
			If dbug Then
				Response.Write("<b>Called XDAL.GetRows():</b><br />")
			End If

			If IsNumeric(rows) Then
				If Application("DBType") = 1 Then
					sql = sql & " Limit "& rows
				Else
					sql = Replace(LCase(sql), "select", "select top "& rows)
				End If
			End If

			Dim objRst, i, strField
			Set objRst = Server.CreateObject("ADODB.Recordset")
			objRst.CursorLocation = 3 'adUseClient
			sql = BuildSQL(sql, params)
			Call objRst.Open(sql, objCnn, 3, 1) 'adOpenStatic, adLockReadOnly
			If objRst.BOF OR objRst.EOF Then
				objRst.Close()
				Set objRst = Nothing
				ReDim arr(0, -1)
			Else
				arr = objRst.GetRows()
				objRst.Close()
				Set objRst = Nothing
			End If
		End Sub
	End Class

	Function HasRows(ByRef arr)
		If UBound(arr, 2) = -1 Then
			HasRows = False
		Else
			HasRows = True
		End If
	End Function
%>