<%
	Function RC4(ByRef varKey, ByRef varData)
		Dim arrKeyBytes(255), arrCypherBytes(255)

		Dim lngKeyLen, lngDataLen
		lngKeyLen = Len(varKey)
		lngDataLen = Len(varData)

		If lngKeyLen < 0 Then Exit Function
		If lngDataLen < 0 Then Exit Function

		Dim i
		For i = 0 To 255
			arrKeyBytes(i) = Asc(Mid(varKey, (((i) Mod (lngKeyLen)) + 1), 1))
		Next

		'key-scheduling algorithm (KSA)
		For i = 0 To 255
			arrCypherBytes(i) = i
		Next

		Dim j, strTmp
		j = 0
		i = 0
			
		For i = 0 To 255
			j = (j + arrCypherBytes(i) + arrKeyBytes(i)) Mod 256
			strTmp = arrCypherBytes(i)
			arrCypherBytes(i) = arrCypherBytes(j)
			arrCypherBytes(j) = strTmp
		Next

		i = 0
		j = 0
				
		'pseudo-random generation algorithm (PRGA)
		Dim x, t
		For x = 1 To lngDataLen
			i = (i + 1) Mod 256
			j = (j + arrCypherBytes(i)) Mod 256
			t = (arrCypherBytes(i) + arrCypherBytes(j)) Mod 256
			strTmp = arrCypherBytes(i)
			arrCypherBytes(i) = arrCypherBytes(j)
			arrCypherBytes(j) = strTmp
			RC4 = RC4 & Chr(Asc(Mid(varData, x, 1)) Xor arrCypherBytes(t))
		Next
	End Function

	Function GenerateKey(ByVal gu, ByVal dtm)
			gu = AscEncode(gu)
			dtm = ISO8601(dtm)
			dtm = AscEncode(dtm)
			GenerateKey = Left((gu & dtm), 255)
	End Function

	'Deprecated encryption routine

	'Code by Simon Carlisle from JuicyStudio
	'Full tutorial here: http://web.archive.org/web/20041025221711/http://juicystudio.com/tutorial/asp/encryption.asp

	Function JuicyStudio(ByVal strEncryptionKey, ByVal strTextToEncrypt)
		' Declare variables
		Dim outer, inner, Key, strTemp
		' For each character in strEncryptionKey
		For outer = 1 To Len(strEncryptionKey)
			' Get a character to use as our encryption 
			' key in this iteration of the OUTER loop
			key = Asc(Mid(strEncryptionKey, outer, 1))
			' For each character in strTextToEncrypt
			For inner = 1 To Len(strTextToEncrypt)
				' Update our encrypted text
				strTemp = strTemp & Chr(Asc(Mid(strTextToEncrypt, inner, 1)) Xor key)
				' Change our encryption key to mix things up in the INNER loop.
				key = (key + Len(strEncryptionKey)) Mod 256
			Next
			' Update the strTextToEncrypt variable before 
			' the next iteration of the OUTER loop
			strTextToEncrypt = strTemp
			' Reset strTemp for the next iteration of the OUTER loop.
			strTemp = ""
		Next
		' Assign the value of the encrypted text to the function name 
		' so we can return the value to the caller
		JuicyStudio = strTextToEncrypt
	End Function

	'Code by Anonymous

	Function AscEncode(str)
		Dim i
		Dim sAscii

		sAscii = ""
		For i = 1 To Len(str)
			'
			Dim sTmp
			sTmp = CStr(Hex(Asc(Mid(str, i, 1))))
			If Len(sTmp) <> 2 Then
				sTmp = "0" & sTmp
			End If
			sAscii = sAscii & sTmp
		Next
		AscEncode = sAscii
	End Function

	Function ChrEncode(str)
		Dim i
		Dim sStr

		sStr = ""
		For i = 1 To Len(str) Step 2
			sStr = sStr & Chr(CLng("&H" & Mid(str, i, 2)))
		Next
		ChrEncode = sStr
	End Function

	'Code by Sean Ringel
	'Function routines for Encryption/Decryption

	Function EncryptText(key, str)
		'Encrypt/Decrypt text
		Dim strEncryptedText
		strEncryptedText = CStr(RC4(key, str))
		EncryptText = AscEncode(strEncryptedText)		
	End Function

	Function DecryptText(key, str)
		'Decode hex encoding
		Dim strDecryptedText
		strDecryptedText = ChrEncode(str)

		'Decrypt text
		strDecryptedText = RC4(key, strDecryptedText)
		DecryptText = strDecryptedText
	End Function
%>