<%
	Function ZeroPad(str, int)
		ZeroPad = String(int - Len(str), "0") & str
	End Function

	Function RFC822(dtm, tzo)
		Dim dtmDate, dtmDay, dtmDays, dtmMonth, dtmYear, dtmHours, dtmMinutes, dtmSeconds
		If IsDate(dtm) Then
			dtm = DateAdd("n", (tzo * 60), dtm)
		Else
			dtm = dtmNow
		End If

		dtmDay = WeekdayName(Weekday(dtm), True)
		dtmDays = ZeroPad(Day(dtm), 2)
		dtmMonth =  MonthName(Month(dtm), True)
		dtmYear = Year(dtm)
		dtmHours = ZeroPad(Hour(dtm), 2)
		dtmMinutes = ZeroPad(Minute(dtm), 2)
		dtmSeconds = ZeroPad(Second(dtm), 2)
		RFC822 = dtmDay & ", " & dtmDays & " " &  dtmMonth & " " & dtmYear & " " & dtmHours & ":" & dtmMinutes & ":" & dtmSeconds & " GMT"
	End Function

	Function ISO8601(dtm)
		If IsDate(dtm) Then
		Else
			dtm = dtmNow
		End If

		Dim  dtmYear, dtmMonth, dtmDays, dtmHours, dtmMinutes, dtmSeconds
		dtmYear = Year(dtm)
		dtmMonth =  ZeroPad(Month(dtm), 2)
		dtmDays = ZeroPad(Day(dtm), 2)
		dtmHours = ZeroPad(Hour(dtm), 2)
		dtmMinutes = ZeroPad(Minute(dtm), 2)
		dtmSeconds = ZeroPad(Second(dtm), 2)
		ISO8601 = dtmYear & dtmMonth & dtmDays & "T" & dtmHours & dtmMinutes & dtmSeconds & "Z"
	End Function

	Function IP2Long(ByVal str)
		Dim arrIP
		arrIP = Split(str, ".")
		
		Dim lngIP
		lngIP = -2147483648
		If IsArray(arrIP) Then
			For i = 0 To 3
				lngIP = lngIP + (arrIP(i)*(256)^(3 - i))
			Next
			Erase arrIP
			IP2Long = lngIP
		Else
			IP2Long = str
		End If
	End Function

	Function Long2IP(ByVal lng)
		If IsNumeric(lng) AND (-2147483647 >= lng <= 2147483648) Then
			Dim lngIP
			lngIP = lng + 2147483648
			Dim i, intNum, strIP
			For i = 1 To 4
				intNum = Int(lngIP/(256)^(4 - i))
				lngIP = lngIP - (intNum*(256)^(4 - i))

				If i <> 4 Then
					strIP = strIP & intNum & "."
				Else
					strIP = strIP & intNum
				End If
			Next
			Long2IP = strIP
		Else
			Long2IP = lng
		End If
	End Function

%>